#include <stdio.h>
#include <stdlib.h>

#define MNJAU 200005

long long T_Slatko[MNJAU];
long long T_Gorko[MNJAU];
long long X_Koo[MNJAU];
long long Y_Koo[MNJAU];

void sWap(long long *a, long long *b){
    long long t=*a; *a=*b; *b=t;
}

int particija(int d, int g){
    long long p=T_Slatko[g];
    int i=(d-1);
    
    for(int j=d; j<=g-1; j++){
        if(T_Slatko[j]<p){
            i++;
            sWap(&T_Slatko[i], &T_Slatko[j]);
            sWap(&T_Gorko[i], &T_Gorko[j]);
        }
    }
    sWap(&T_Slatko[i+1], &T_Slatko[g]);
    sWap(&T_Gorko[i+1], &T_Gorko[g]);
    return (i+1);
}

void sOrtujMe(int d, int g){
    if(d<g){
        int pi=particija(d, g);
        sOrtujMe(d, pi-1);
        sOrtujMe(pi+1, g);
    }
}

long long aps(long long a) {
    return a > 0 ? a : -a;
}

int main() {
    int N;
    if(scanf("%d", &N) != 1)return 1;

    for(int i=0;i<N;i++){
        if(scanf("%lld %lld", &X_Koo[i], &Y_Koo[i])!=2)return 1;
    }

    long long s=0;
    int Smerovi[4][2] = {{0, 1}, {0, -1}, {1, 0}, {-1, 0}};

    for(int d1=0;d1<4;d1++){
        for(int d2=0;d2<4;d2++){
            
            long long ddx=Smerovi[d2][0]-Smerovi[d1][0];
            long long ddy=Smerovi[d2][1]-Smerovi[d1][1];
            
            if(ddx==0 && ddy==0)continue;
            
            for(int i=0;i<N;i++){
                if(ddx==0){
                    T_Slatko[i]=X_Koo[i];
                    T_Gorko[i]=Y_Koo[i];
                }else if(ddy==0){
                    T_Slatko[i]=Y_Koo[i];
                    T_Gorko[i]=X_Koo[i];
                }else{
                    T_Slatko[i]=X_Koo[i]*ddy-Y_Koo[i]*ddx;
                    T_Gorko[i]=X_Koo[i]*ddx+Y_Koo[i]*ddy;
                }
            }
            
            sOrtujMe(0, N-1);
            
            int i=0;
            while(i<N){
                int j=i;
                while(j<N && T_Slatko[j]==T_Slatko[i]){
                    j++;
                }
                
                if(j-i>1){
                    int k=i;
                    while(k<j){
                        int l=k;
                        while(l<j && T_Gorko[l]==T_Gorko[k]){
                            l++;
                        }
                        
                        long long br=l-k;
                        
                        // Provera t > 0
                        
                        if(ddx==0){
                             long long delta_y=Y_Koo[k]-Y_Koo[l-1];
                             if(delta_y*ddy > 0 && delta_y%ddy==0){
                                long long t=delta_y/ddy;
                                if(t>0)s+=br*(br-1)/2;
                             }
                        }else{
                            long long delta_x=X_Koo[k]-X_Koo[l-1];
                             if(delta_x*ddx > 0 && delta_x%ddx==0){
                                long long t=delta_x/ddx;
                                if(t>0)s+=br*(br-1)/2;
                             }
                        }
                        
                        k=l;
                    }
                }
                i=j;
            }
        }
    }
    
    printf("%lld\n", s);
    return 0;
}